IF EXISTS ( SELECT * FROM sysobjects WHERE  id = object_id(N'CPJ_xVentanas_Equates_Get') and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CPJ_xVentanas_Equates_Get 
END
GO


CREATE PROCEDURE [dbo].[CPJ_xVentanas_Equates_Get] @pJson VARCHAR(8000) 
AS

DECLARE @sql NVARCHAR(MAX) 

DECLARE @pId_Ventana VARCHAR(100) 
DECLARE @pId_Usuario VARCHAR(10) 
DECLARE @pDebug VARCHAR(5) 

DECLARE @Filtro_Flag VARCHAR(250)
DECLARE @HasGroup INT
DECLARE @Flag_Type VARCHAR(50)

SET @pId_Ventana	= ISNULL(CONVERT(VARCHAR(100), dbo.CF_JSON_VALUE(@pJson,'Id_Ventana')), '')
SET @pId_Usuario	= ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJson,'Id_Usuario')), '')
SET @pDebug			= ISNULL(CONVERT(VARCHAR(5), dbo.CF_JSON_VALUE(@pJson,'Debug')), '')
SET @Flag_Type		= ISNULL(CONVERT(VARCHAR(50), dbo.CF_JSON_VALUE(@pJson,'Flag_Type')), 'Flag_Todas')

SET @Filtro_Flag = @Flag_Type + ' = 1'
-- Si no es Flag_todas entonces chequeo siempre por Flag_Todas y el Flag especifico
IF(@Flag_Type != 'Flag_Todas')
BEGIN
	SET @Filtro_Flag = '(Flag_Todas = 1 OR ' + @Flag_Type + ' = 1)'
END

IF(@pDebug = 1)
BEGIN
	PRINT 'Where Flag: ' + @Filtro_Flag
END


-- Creo la tabla temporal
CREATE TABLE #Equates (
	Id_Ventana VARCHAR(100), 
	Id_Usuario VARCHAR(5), 
	Nombre VARCHAR(200), 
	Fuente_Tipo VARCHAR(200), 
	Fuente_Tam VARCHAR(200), 
	Color_Texto VARCHAR(200), 
	Texto VARCHAR(200), 
	Etiqueta VARCHAR(200), 
	Valor VARCHAR(200), 
	Justificacion VARCHAR(10), 
	
	Ocultar char(1),
	Requerido char(1),
	Deshabilitado char(1),

	Flag_Agregar char(1), 
	Flag_Cambiar char(1),
	Flag_Borrar char(1), 
	Flag_Ver char(1), 
	Flag_Todas char(1),

	Flag_Modif char(1)
)


-- Busco los datos de la tabla xVentana_Items y lo guardo en la tabla temporal
SET @sql = '
INSERT INTO #Equates 
SELECT Id_Ventana, '''' as Id_Usuario, Nombre, Fuente_Tipo, Fuente_Tam, Color_Texto, Texto, Etiqueta, Valor, Justificacion, Ocultar, Requerido, Deshabilitado, Flag_Agregar, Flag_Cambiar, Flag_Borrar, Flag_Ver, Flag_Todas, Flag_Modif
FROM xVentanas_Items
WHERE Id_Ventana = @pId_Ventana AND Flag_Modif = 1 AND Nombre != '''' AND ' + @Filtro_Flag

EXEC sp_executesql @sql, N'@pId_Ventana NVARCHAR(MAX)', @pId_Ventana

IF(@pDebug = 1)
BEGIN
	PRINT 'SQL tabla temporal Equates: '
	PRINT @sql 
	PRINT '--END | tabla temporal Equates -- '
END


-- Si manda un Id_Usuario
IF (@pId_Usuario != '') 
BEGIN
	
	-- Chequeo si pertenece a un grupo
	SET @HasGroup = ISNULL((SELECT 1 FROM Seg_UserInGroup WHERE UserNo = @pId_Usuario GROUP BY UserNo), 0)
	IF(@pDebug = 1)
	BEGIN
		PRINT 'Tiene grupo: ' + CAST(@HasGroup as varchar(1))
	END 

	IF(@HasGroup = 1)
	BEGIN

		-- Declaro las variables para leer los valores de la consulta
		DECLARE @GU_Item_Id_Ventana varchar(100), @GU_Item_Id_Usuario VARCHAR(5), @GU_Item_Nombre VARCHAR(200), @GU_Item_Fuente_Tipo INT, @GU_Item_Fuente_Tam VARCHAR(200), @GU_Item_Color_Texto VARCHAR(200), @GU_Item_Texto VARCHAR(200), @GU_Item_Etiqueta VARCHAR(200), @GU_Item_Valor VARCHAR(200), @GU_Item_Justificacion varchar(10) 
		DECLARE @GU_Item_Flag_Agregar char(1), @GU_Item_Flag_Cambiar char(1), @GU_Item_Flag_Borrar char(1), @GU_Item_Flag_Ver char(1), @GU_Item_Flag_Todas char(1), @GU_Item_Flag_Modif char(1)
		DECLARE @GU_Item_Requerido VARCHAR(1), @GU_Item_Ocultar VARCHAR(1), @GU_Item_Deshabilitado VARCHAR(1)

		-- Crear una tabla temporal para almacenar los resultados de la consulta dinmica
		CREATE TABLE #TempEquatesPoGrupoDeUsuario (
			Id_Ventana NVARCHAR(MAX),
			Id_Usuario INT,
			Nombre NVARCHAR(MAX),
			Fuente_Tipo NVARCHAR(MAX),
			Fuente_Tam NVARCHAR(MAX),
			Color_Texto NVARCHAR(MAX),
			Texto NVARCHAR(MAX),
			Etiqueta NVARCHAR(MAX),
			Valor NVARCHAR(MAX),
			Justificacion NVARCHAR(MAX),
			Ocultar NVARCHAR(MAX),
			Requerido NVARCHAR(MAX),
			Deshabilitado NVARCHAR(MAX),
			Flag_Agregar INT,
			Flag_Cambiar INT,
			Flag_Borrar INT,
			Flag_Ver INT,
			Flag_Todas INT,
			Flag_Modif INT
		)
		SET @sql = '
		INSERT INTO #TempEquatesPoGrupoDeUsuario
		SELECT 
			eu.Id_Ventana, eu.Id_Usuario, eu.Nombre, eu.Fuente_Tipo, eu.Fuente_Tam, eu.Color_Texto, eu.Texto, eu.Etiqueta, eu.Valor, eu.Justificacion, eu.Ocultar, eu.Requerido, eu.Deshabilitado, eu.Flag_Agregar, eu.Flag_Cambiar, eu.Flag_Borrar, eu.Flag_Ver, eu.Flag_Todas, eu.Flag_Modif
		FROM 
			Seg_UserInGroup gu, 
			xVentanas_Items_Users eu 
		WHERE 
			gu.UserNo = @pId_Usuario AND 
			gu.UGrpNo = eu.Id_Usuario AND 
			eu.Id_Ventana = @pId_Ventana AND 
			eu.Nombre != '''' AND 
			eu.Flag_Modif = 1 AND ' + @Filtro_Flag

		-- Ejecuto la consulta para guardar los resultados
		EXEC sp_executesql @sql, N'@pId_Ventana NVARCHAR(MAX), @pId_Usuario INT', @pId_Ventana, @pId_Usuario
		
		IF(@pDebug = 1)
		BEGIN
			PRINT 'SQL tabla temporal TempEquatesPoGrupoDeUsuario: '
			PRINT @sql 
			PRINT '--END | tabla temporal TempEquatesPoGrupoDeUsuario -- '
		END

		-- Cursor de equates para los grupos del usuario
		DECLARE cursorEquatesPoGrupoDeUsuario CURSOR FOR SELECT * FROM #TempEquatesPoGrupoDeUsuario
		OPEN cursorEquatesPoGrupoDeUsuario
		FETCH NEXT FROM cursorEquatesPoGrupoDeUsuario INTO @GU_Item_Id_Ventana, @GU_Item_Id_Usuario, @GU_Item_Nombre, @GU_Item_Fuente_Tipo, @GU_Item_Fuente_Tam, @GU_Item_Color_Texto, @GU_Item_Texto, @GU_Item_Etiqueta, @GU_Item_Valor, @GU_Item_Justificacion, @GU_Item_Ocultar, @GU_Item_Requerido, @GU_Item_Deshabilitado, @GU_Item_Flag_Agregar, @GU_Item_Flag_Cambiar, @GU_Item_Flag_Borrar, @GU_Item_Flag_Ver, @GU_Item_Flag_Todas, @GU_Item_Flag_Modif
		
		-- Bucle
		WHILE @@FETCH_STATUS = 0
		BEGIN

			IF(@pDebug = 1)
			BEGIN 
				PRINT 'Grupo ' + @GU_Item_Id_Usuario
				PRINT 'Datos Pre Select'
				PRINT 'Ocultar: ' + @GU_Item_Ocultar
				PRINT 'Requerido: ' + @GU_Item_Requerido
				PRINT 'Deshabilidato: ' + @GU_Item_Deshabilitado
			END 

			-- Piso lo que se haya cargado en xVentanas_Items
			SELECT 
				@GU_Item_Ocultar		= (CASE WHEN Ocultar		= '1' THEN '1' ELSE @GU_Item_Ocultar END), 
				@GU_Item_Requerido		= (CASE WHEN Requerido		= '1' THEN '1' ELSE @GU_Item_Requerido END), 
				@GU_Item_Deshabilitado	= (CASE WHEN Deshabilitado	= '1' THEN '1' ELSE @GU_Item_Deshabilitado END)
			FROM 
				#Equates 
			WHERE 
				Nombre = @GU_Item_Nombre AND 
				Id_Ventana = @GU_Item_Id_Ventana

			IF(@pDebug = 1)
			BEGIN 
				/* PRINT '@GU_Item_Nombre: ' + @GU_Item_Nombre
				PRINT '@GU_Item_Id_Ventana: ' + @GU_Item_Id_Ventana
				PRINT '@GU_Item_Id_Usuario: ' + @GU_Item_Id_Usuario */

				PRINT 'Datos Post Select'
				PRINT 'Ocultar: ' + @GU_Item_Ocultar
				PRINT 'Requerido: ' + @GU_Item_Requerido
				PRINT 'Deshabilidato: ' + @GU_Item_Deshabilitado

			END 

			-- Elimino el registro que haya antes
			DELETE FROM #Equates WHERE Nombre = @GU_Item_Nombre AND Id_Ventana = @GU_Item_Id_Ventana

			-- Inserto el registro 
			INSERT INTO #Equates SELECT @GU_Item_Id_Ventana, @GU_Item_Id_Usuario, @GU_Item_Nombre, @GU_Item_Fuente_Tipo, @GU_Item_Fuente_Tam, @GU_Item_Color_Texto, @GU_Item_Texto, @GU_Item_Etiqueta, @GU_Item_Valor, @GU_Item_Justificacion, @GU_Item_Ocultar, @GU_Item_Requerido, @GU_Item_Deshabilitado, @GU_Item_Flag_Agregar, @GU_Item_Flag_Cambiar, @GU_Item_Flag_Borrar, @GU_Item_Flag_Ver, @GU_Item_Flag_Todas, @GU_Item_Flag_Modif


			-- Seteo los datos
			FETCH NEXT FROM cursorEquatesPoGrupoDeUsuario INTO @GU_Item_Id_Ventana, @GU_Item_Id_Usuario, @GU_Item_Nombre, @GU_Item_Fuente_Tipo, @GU_Item_Fuente_Tam, @GU_Item_Color_Texto, @GU_Item_Texto, @GU_Item_Etiqueta, @GU_Item_Valor, @GU_Item_Justificacion, @GU_Item_Ocultar, @GU_Item_Requerido, @GU_Item_Deshabilitado, @GU_Item_Flag_Agregar, @GU_Item_Flag_Cambiar, @GU_Item_Flag_Borrar, @GU_Item_Flag_Ver, @GU_Item_Flag_Todas, @GU_Item_Flag_Modif
		END
		CLOSE cursorEquatesPoGrupoDeUsuario
		DEALLOCATE cursorEquatesPoGrupoDeUsuario

	END -- Check Grupos de usuarios



	-- Declarar variables para el cursor (lo voy a usar para los grupos y para los usuarios)
	DECLARE @Id_Ventana varchar(100), @Id_Usuario VARCHAR(5), @Nombre VARCHAR(200), @Fuente_Tipo VARCHAR(200), @Fuente_Tam VARCHAR(200), @Color_Texto VARCHAR(200), @Texto VARCHAR(200), @Etiqueta VARCHAR(200), @Valor VARCHAR(200), @Justificacion varchar(10), @Ocultar char(1), @Requerido char(1), @Deshabilitado char(1), @Flag_Agregar char(1), @Flag_Cambiar char(1), @Flag_Borrar char(1), @Flag_Ver char(1),
	@Flag_Todas char(1), @Flag_Modif char(1)

	
	-- Crear una tabla temporal para almacenar los resultados de la consulta dinmica
	CREATE TABLE #TempEquatesUsuario (
		Id_Ventana NVARCHAR(MAX),
		Id_Usuario INT,
		Nombre NVARCHAR(MAX),
		Fuente_Tipo NVARCHAR(MAX),
		Fuente_Tam NVARCHAR(MAX),
		Color_Texto NVARCHAR(MAX),
		Texto NVARCHAR(MAX),
		Etiqueta NVARCHAR(MAX),
		Valor NVARCHAR(MAX),
		Justificacion NVARCHAR(MAX),
		Ocultar NVARCHAR(MAX),
		Requerido NVARCHAR(MAX),
		Deshabilitado NVARCHAR(MAX),
		Flag_Agregar INT,
		Flag_Cambiar INT,
		Flag_Borrar INT,
		Flag_Ver INT,
		Flag_Todas INT,
		Flag_Modif INT
	)
	SET @sql = '
	INSERT INTO #TempEquatesUsuario
	SELECT 
		Id_Ventana, Id_Usuario, Nombre, Fuente_Tipo, Fuente_Tam, Color_Texto, Texto, Etiqueta, Valor, Justificacion, Ocultar, Requerido, Deshabilitado, Flag_Agregar, Flag_Cambiar, Flag_Borrar, Flag_Ver, Flag_Todas, Flag_Modif
	FROM 
		xVentanas_Items_Users
	WHERE 
		Id_Ventana=@pId_Ventana AND 
		Id_Usuario=@pId_Usuario AND 
		Nombre != '''' AND 
		Flag_Modif = 1  AND ' + @Filtro_Flag

	-- Ejecuto la consulta para guardar los resultados
	EXEC sp_executesql @sql, N'@pId_Ventana NVARCHAR(MAX), @pId_Usuario INT', @pId_Ventana, @pId_Usuario
		
	IF(@pDebug = 1)
	BEGIN
		PRINT 'SQL tabla temporal TempEquatesUsuario: '
		PRINT @sql 
		PRINT '--END | tabla temporal TempEquatesUsuario -- '
	END


	-- Cursor de equates personalizados para el usuario
	DECLARE cursorXVentanasItemsUser CURSOR FOR SELECT * FROM #TempEquatesUsuario
	OPEN cursorXVentanasItemsUser
	FETCH NEXT FROM cursorXVentanasItemsUser INTO @Id_Ventana, @Id_Usuario, @Nombre, @Fuente_Tipo, @Fuente_Tam, @Color_Texto, @Texto, @Etiqueta, @Valor, @Justificacion, @Ocultar, @Requerido, @Deshabilitado, @Flag_Agregar, @Flag_Cambiar, @Flag_Borrar, @Flag_Ver, @Flag_Todas, @Flag_Modif

	-- Bucle
	WHILE @@FETCH_STATUS = 0
	BEGIN
		-- Si tiene un registro lo elimino para luego insertarlo
		DELETE FROM #Equates WHERE Nombre = @Nombre AND Id_Ventana = @Id_Ventana

		-- Piso el valor de la tabla general
		INSERT INTO #Equates SELECT @Id_Ventana, @Id_Usuario, @Nombre, @Fuente_Tipo, @Fuente_Tam, @Color_Texto, @Texto, @Etiqueta, @Valor, @Justificacion, @Ocultar, @Requerido, @Deshabilitado, @Flag_Agregar, @Flag_Cambiar, @Flag_Borrar, @Flag_Ver, @Flag_Todas, @Flag_Modif


		FETCH NEXT FROM cursorXVentanasItemsUser INTO @Id_Ventana, @Id_Usuario, @Nombre, @Fuente_Tipo, @Fuente_Tam, @Color_Texto, @Texto, @Etiqueta, @Valor, @Justificacion, @Ocultar, @Requerido, @Deshabilitado, @Flag_Agregar, @Flag_Cambiar, @Flag_Borrar, @Flag_Ver, @Flag_Todas, @Flag_Modif
	END
	CLOSE cursorXVentanasItemsUser
	DEALLOCATE cursorXVentanasItemsUser
		
END -- End @pId_Usuario != ''

IF(@pDebug = 1)
BEGIN
	DROP TABLE #Equates
	return
END 

-- Hago un Select de la tabla temporal 
SELECT * FROM #Equates

-- Hago un delete de la tabla temporal
DROP TABLE #Equates

-- EXEC CPJ_xVentanas_Equates_Get '{"Id_Ventana":"Clientes","Id_Usuario":"11","Debug":"1"}'
GO


